package com.example.opteamscreen

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.content.SharedPreferences
import android.os.Build
import android.os.Bundle
import android.os.Looper
import android.text.Editable
import android.text.TextWatcher
import android.view.View
import android.view.WindowManager
import android.widget.Button
import android.widget.EditText
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import okhttp3.*
import org.json.JSONArray
import org.json.JSONObject
import java.io.IOException


class MainActivity : AppCompatActivity() {

    private var mGreetingTextView: TextView? = null
    private var mNameEditText: EditText? = null
    private var mPlayButton: Button? = null
    private val client = OkHttpClient()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (Build.VERSION.SDK_INT < 16) {
            window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN)
        }else{
            window.decorView.systemUiVisibility = View.SYSTEM_UI_FLAG_FULLSCREEN
        }

        supportActionBar?.hide()
        setContentView(R.layout.activity_main)
        val sharedPref = this@MainActivity.getPreferences(Context.MODE_PRIVATE)

        val SAVEDURL: String? = sharedPref.getString("SAVED_URL", "")
        if (SAVEDURL != ""){
            val intent = Intent(this@MainActivity, MyscreenActivite::class.java)
            intent.putExtra("url", SAVEDURL)
            startActivity(intent)
        }else {
            mGreetingTextView = findViewById<TextView>(R.id.main_textview_greeting)
            mNameEditText = findViewById<EditText>(R.id.main_edittext_name)
            mPlayButton = findViewById<Button>(R.id.main_button_play)

            // mPlayButton?.isEnabled = false

            mNameEditText?.addTextChangedListener(object : TextWatcher {
                override fun beforeTextChanged(
                    s: CharSequence,
                    start: Int,
                    count: Int,
                    after: Int
                ) {
                }

                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                }

                override fun afterTextChanged(s: Editable?) {
                    mPlayButton?.isEnabled = s.toString().isNotEmpty()
                }
            })

            mPlayButton?.setOnClickListener {
                var url: String = "https://happydisplay.opteam.net/wp-json/wp/v2/pages"
                var code: String? = mNameEditText?.text.toString()
                Thread {
                    Looper.prepare()
                    val request = Request.Builder()
                        .url(url)
                        .build()
                    var testurl: String? = null
                    client.newCall(request).execute().use { response ->
                        if (!response.isSuccessful) throw IOException("Unexpected code $response")
                        var list: String? = response.body?.string()
                        var Jarray: JSONArray = JSONArray(list)
                        for(i in 0 until Jarray.length()){
                            var JObject: JSONObject = Jarray.getJSONObject(i)
                            var acf: JSONObject = JObject.getJSONObject("acf")
                            if(acf.getString("code_ecran") == code){
                                testurl = JObject.getString("link")
                            }
                        }
                    }
                    if(testurl != null){
                        with(sharedPref.edit()){
                            putString("SAVED_URL",testurl)
                            apply()
                        }
                        val intent = Intent(this@MainActivity, MyscreenActivite::class.java)
                        intent.putExtra("url", testurl)
                        startActivity(intent)
                    }
                    Looper.loop()
                }.start()
            }
        }

    }

}
